/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
Game::ObjMemx<Game::Chr   > Chrs   ;
Game::ObjMemx<Game::Static> Statics;

Marker marker; // marker pointing character destination target
/******************************************************************************/
void InitPre()
{
   App.name="Pathfind";
   App.flag=APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3);

   ViewportFull.range=50;
   Cam.dist = 10;
   Cam.yaw  =-PI_4;
   Cam.pitch=-PI_3;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sun    .set(*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower();
   Sky    .set();

   Game::World.init   (                  )
              .setType(Chrs   ,OBJ_CHR   )
              .setType(Statics,OBJ_STATIC)
              .New    ("world/path"      )
              .update (Cam.at            );

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Game::World.update(Cam.at);

   // move player
   if(Ms.bp(0) && Chrs.elms()) // on LMB pressed
   {
      Vec     pos,dir ; ScreenToPosDir(Ms.pos,pos,dir); // convert screen mouse position to world position and direction
      PhysHit phys_hit;
      if(Physics.ray(pos,dir*Viewport.range,&phys_hit)) // if ray-test hit something
      {
         Chrs[0].actionMoveTo(phys_hit.plane.p); // order character to move to that location

         marker.color=YELLOW;
         marker.size=2;
         marker.range_opaque=0.1;
         marker.range_fade  =0.2;
         marker.gfx=Gfxs("gfx/particle/star.gfx");
         marker.local_matrix.setPosDir(phys_hit.plane.p,Vec(0,1,0));
      }
   }

   // rotate camera
   if(Ms.b(1))
   {
      Cam.yaw  -=Ms.dir_d.x;
      Cam.pitch+=Ms.dir_d.y;
   }
   Cam.setSpherical(Chrs[0].pos(),Cam.yaw,Cam.pitch,0,Cam.dist*ScaleMul(Ms.wheel*-0.2)).updateVelocities().set();

   // rotate marker around its z axis
   marker.local_matrix.orn.rotateZVec(Tm.d);

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
   
   switch(Renderer())
   {
      case RM_PRT_BLN:
         if(Chrs[0].action==Game::ACTION_MOVE_TO)marker.draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);

   // show blocked places
   if(Kb.b(KB_SPACE)) // if space pressed
      if(Chrs.elms()) // if at least one character is available
   {
      Vec   pos     =Chrs[0].pos(); // get character position
      VecI2 area_pos=Game::World.worldToAreaPos(pos); // convert from world position to area coordinates
      if(const Game::Area::Path *path=Game::World.pathGet(area_pos)) // if found paths at given coordinates
      {
         D.clearZ(); // clear Z Buffer

         Vec world_pos=Game::World.areaToWorldPos(area_pos).x0y();  // convert 2D Area Coordinates to 3D World Position
         Flt cell_size=(1.0f/AREA_PATH_RES)*Game::World.areaSize(); // get size of a single path cell

         VI.color(ColorAlpha(RED,0.5f)); // set drawing color to transparent RED
         REPD(y,AREA_PATH_RES)
         REPD(x,AREA_PATH_RES)if(!path->walkable(x,y)) // if current cell isn't walkable
         {
            Vec pos=world_pos+Vec(x,0,y)*cell_size; // get world position of a single path cell

            VI.quad(pos+Vec(        0,0,cell_size), // draw a quad which extends 'pos' to right and forward by 'cell_size'
                    pos+Vec(cell_size,0,cell_size),
                    pos+Vec(cell_size,0,        0),
                    pos+Vec(        0,0,        0));
         }
         VI.end();
      }
   }

   // informations
   D.text(0,0.9,"Press LMB to move player, RMB to rotate camera");
   D.text(0,0.8,"Press Space to show blocked places at character position");
}
/******************************************************************************/
